/*
 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

 /**
  *
  * \file   platform_test.h
  *
  * \brief  This file contains structure, typedefs, functions and
  *         prototypes used for audio line in loopback test
  *
 *****************************************************************************/

#ifndef _PLATFORM_H_
#define _PLATFORM_H_

#include <stdio.h>
#include "DM388_EVM.h"
#include "DM388_types.h"
#include "uart.h"
#include "nandflash.h"
#include "ddr3.h"
#include "ti816x_usbss.h"
#include "led.h"
#include "sdmmc.h"
#include "bluetooth.h"
#include "aic3104.h"
#include "switch.h"
#include "emac.h"
#include "DM388_i2c.h"
#include "gpio.h"
#include "camera.h"

typedef INT16 RET_STATUS;

#define PLATFORM_TEST_AUTO_ALL     (0)
#define PLATFORM_TEST_START        (1)
#define PLATFORM_AUTO_TEST_COUNT   (11)
#define PLATFORM_TEST_COUNT        (12)

/* Platform test return codes */
#define TEST_PASS     (0)
#define TEST_FAIL     (-1)


/**
 *  \brief    Diagnostic test main function
 *
 *  \return   Platform_STATUS
 */
INT32 diag_main (void);

INT32 platform_write(const char *fmt, ...);
INT32 platform_read(UINT8 *data, UINT32 length);

/**
 * @brief Define how platform_write should behave.
 *    These write types can be set in the init structure
 */
typedef enum {
    PLATFORM_WRITE_UART,
    /** <Write to the UART */
    PLATFORM_WRITE_PRINTF,
    /** <printf mapped output -- CCS console */
    PLATFORM_WRITE_ALL
    /** <write all - default configuration */
} WRITE_info;

/**
 * @brief Define how platform_read should behave.
 *    These write types can be set in the init structure
 */
typedef enum {
    PLATFORM_READ_UART,
    /** <Read from the UART */
    PLATFORM_READ_SCANF
    /** <Read from scanf -- CCS console */
} READ_info;

typedef struct diagTestTable_s
{
	const char *testName;
	INT32 (*testFunction)(void *);
	void  *args;
	UINT32  pass;
	UINT32 fail;
}diagTestTable_t;

#endif
